﻿package{
	import flash.events.*
	import flash.display.*;
	import flash.net.*;
	import flash.utils.Timer;
	import CommonFunctions;
	
	public class Uploader extends MovieClip{
		public var ref = new FileReference();
		public var refList = new FileReferenceList();
		public var urlUpload:String = "";
		public var strUploadFiletype:String = "images";
		public var windowMessageTextDelay:Number = 700;
		public var arrFileTypes:Array;
		public var dispatcher:EventDispatcher = new EventDispatcher();
		public var startTime:Number;
		public var uploadCategoryId:Number = -1;
		
		private var requestUpload:URLRequest;
		private var mc_progressWindow:FileUploadProgessWindow = new FileUploadProgessWindow();
		private var uploadFileCounter = 0;
		private var timerMessage:Timer;		//count message timer for the upload window.
		
		//constructor:
		public function Uploader(){
			initReferenceListEvents();
			initUploadWindowEvents();
		}
				
		//---------------------------------------------------------------------
		// set the upload url
		public function setUploadUrl(url:String){
			this.urlUpload = url;
		}
		
		//---------------------------------------------------------------------
		// set upload category
		public function setUploadCategoryId(cat){
			this.uploadCategoryId = cat;
		}
		
		//---------------------------------------------------------------------
		// set upload filetypes string (dor the dialog)
		public function setUploadTypeString(str){
			this.strUploadFiletype = str;
		}
		
		//---------------------------------------------------------------------
		// set the upload url
		private function setUploadRequest(){
			this.requestUpload = new URLRequest(this.urlUpload);
			
			var variables:URLVariables = new URLVariables();
			variables.clientAction = "uploadfile";
			variables.uploadCategoryId = this.uploadCategoryId;
			
			//add demo if needed
			if (MainClass.numDemo != "")
				variables.demo = MainClass.numDemo;
			
			this.requestUpload.method = URLRequestMethod.POST;
			this.requestUpload.data = variables;
		}
		
		//---------------------------------------------------------------------
		// set upload window events.
		public function initUploadWindowEvents(){
			this.mc_progressWindow.dispatcher.addEventListener("uploadCancelClick",cancelUploadHandler);
		}
		
		
		//---------------------------------------------------------------------
		//init file reference evens.
		private function initReferenceListEvents(){
			dispatcher.addEventListener("customError",customErrorHandler);
			refList.addEventListener(Event.SELECT, uploadSelectHandler);
            refList.addEventListener(Event.OPEN, uploadOpenHandler);
			refList.addEventListener(Event.CANCEL, uploadCancelHandler);
		}
		
		//---------------------------------------------------------------------
		//set file reference events (from list of file references)
		private function setReferenceEvents(ref:FileReference){
            ref.addEventListener(Event.COMPLETE, uploadCompleateHandler);
            ref.addEventListener(IOErrorEvent.IO_ERROR, uploadIoErrorHandler);
            ref.addEventListener(ProgressEvent.PROGRESS, uploadProgressHandler);
            ref.addEventListener(SecurityErrorEvent.SECURITY_ERROR, uploadSecurityErrorHandler);
		}
		
		//---------------------------------------------------------------------
		// set custom error event
		private function throwError(text:String){
			dispatcher.dispatchEvent(new ErrorEvent("customError",false,false,text));
		}
		
		//---------------------------------------------------------------------
		//set upload types for the upload.
		public function setUploadFileTypes(type:String){
			switch(type){
				case "images":
					//set images filter
					this.arrFileTypes = null;
					this.arrFileTypes = new Array();			
					var imagesFilter1:FileFilter = new FileFilter("All images (jpg,jpeg,gif,png,bmp)", "*.jpg;*.jpeg;*.gif;*.png;*.bmp");
					this.arrFileTypes.push(imagesFilter1);
				break;
			}			
			var allFilesFilter:FileFilter = new FileFilter("All files", "*.*");								
			this.arrFileTypes.push(allFilesFilter);
		}
		
		//---------------------------------------------------------------------
		//start upload process - open upload dialog
		public function startUpload(){
			if(this.urlUpload == ""){
				throwError("no upload url, can't upload");
				return(false);
			}
			
			setUploadFileTypes(strUploadFiletype);			
			this.refList.browse(this.arrFileTypes);
		}
		
		//----------------------------------------------------------------
		// close the upload window. show a message before. (optional)
		public function closeUploadWindow(message:String,messageType:String){
			switch(messageType){				
				case "success":
					mc_progressWindow.setSuccessMessage(message);
				break;				
				case "fail":
				default:
					mc_progressWindow.setFailMessage(message);
				break;
			}
			
			//start timer, at the end closes the window
			this.timerMessage = new Timer(windowMessageTextDelay,1);
            timerMessage.addEventListener("timer", timerHandler);
            timerMessage.start();
		}
		
		public function timerHandler(event:TimerEvent){
			this.removeChild(mc_progressWindow);
			throwCompleteEvent();
		}
		
		//----------------------------------------------------------------
		// show the upload window with all parameters
		private function showUploadWindow(ref:FileReference){
			mc_progressWindow.resetView();
			mc_progressWindow.setFilename(ref.name); 
			mc_progressWindow.setPercentNumber(0);
			mc_progressWindow.updateView();
			this.addChild(mc_progressWindow);
			mc_progressWindow.setViewInitSettings();
			
			mc_progressWindow.x=100;
			mc_progressWindow.y=100;
		}
		
		//----------------------------------------------------------------
		// get current file reference, set it's events, and start upload.
		private function uploadNextFile(){
			if(this.uploadFileCounter >= this.refList.fileList.length){
				uploadFilesComplete();
				return(false);
			}
			
			var ref:FileReference = this.refList.fileList[this.uploadFileCounter];
			
			setReferenceEvents(ref);
			
			showUploadWindow(ref);
			ref.upload(this.requestUpload);
			
			//init 
			var date = new Date();
			this.startTime = date.time;
		}
		
		//----------------------------------------------------------------
		//throws compleate event to parent.
		function throwCompleteEvent(){
			dispatcher.dispatchEvent(new Event("uploadCompleted"));
		}
		
		//----------------------------------------------------------------
		// upload event handlers:
		//----------------------------------------------------------------		
		
		// set upload window, show it on the screen, prepare request, and start uploading the first file.
		private function uploadSelectHandler(event:Event){
			dispatcher.dispatchEvent(new Event("uploadStarted"));
			this.uploadFileCounter = 0;
			setUploadRequest();
			uploadNextFile();
		}
		
		//----------------------------------------------------------------				
		// not a handler, but sort of. callen when all list of files complete uploading.
		function uploadFilesComplete(){
			closeUploadWindow("Files uploading complete!","success");
		}
		
		//----------------------------------------------------------------				
		// cancel upload process of the reference.
		public function cancelUploadHandler(event:Event){
			var ref:FileReference = refList.fileList[this.uploadFileCounter];
			ref.cancel();
			closeUploadWindow("Upload canceled!","fail");
		}	
		
		//----------------------------------------------------------------		
		//trace custom event error
		private function customErrorHandler(event:ErrorEvent){
			trace("Uploader error!!! - "+event.text);
		}
		
		//----------------------------------------------------------------		
		//close the window when upload compete.
		private function uploadCompleateHandler(event:Event){
			this.uploadFileCounter++;
			uploadNextFile();			
		}
		
		//----------------------------------------------------------------		
		//io error handler - trace the error.
		private function uploadIoErrorHandler(event:IOErrorEvent){
			trace(event.text);
		}
		
		//----------------------------------------------------------------		
		//security error handler - trace the error.
		private function uploadSecurityErrorHandler(event:SecurityErrorEvent){
			trace(event.text);
		}
				
		//----------------------------------------------------------------		
		// get progress string of number of kb loaded and kb total, and speed.
		private function getProgressString(bytesLoaded:Number,bytesTotal:Number,speed:Number,remainSeconds:Number):String{
			var str:String = new String();
			var strRemain:String = "";
			var unitsRemain:String = " sec";
			
			strRemain = String(Math.ceil(remainSeconds));
			if(remainSeconds>60){
				strRemain = String(Math.ceil(remainSeconds/60));
				unitsRemain = " min";
			}
			
			str = "Uploaded: " + CommonFunctions.formatNumberComas(bytesLoaded) + " bytes";
			str += ", Speed: " + CommonFunctions.formatDecimals(speed,2) + " kb/sec";
			str += ", " + strRemain + unitsRemain;
			return(str);
		}
		
		//upoad progree handler. throw to the upload window the progress data
		private function uploadProgressHandler(event:ProgressEvent){
			mc_progressWindow.setPercent(event.bytesTotal,event.bytesLoaded);
			
			// calculate the time spent from upload start
			var date:Date = new Date();
			var endTime:Number = (date.time-this.startTime)/1000;
			var speed:Number = (event.bytesLoaded/1024) / endTime;		//speed in kb/sec
			var remainSeconds:Number = (event.bytesTotal - event.bytesLoaded) / 1024 / speed; // remain time in seconds
			
			var str:String = getProgressString(event.bytesLoaded,event.bytesTotal,speed,remainSeconds);
			
			mc_progressWindow.setTopLineText(str);
			
			mc_progressWindow.updateView(); //update the progress bar
		}
		
		// on upload cancel click
		private function uploadCancelHandler(event:Event){
			//trace("canceled");
		}
		
		// on upload open click
		private function uploadOpenHandler(event:Event){
			//trace("opened");
		}
		
	}	
}